#!/bin/sh

check_package() {
	pack=`opkg list-installed | grep $1`
	if [ ${#pack} == "0" ]
	then
		return 1
	else
		return 0
	fi
}

check_module() {
	mod=`lsmod | grep $1`
	if [ ${#mod} == "0" ]
	then
		return 1
	else
		return 0
	fi
}

check_run() {
	for DIR in $(find /sys/class/dvb/ -maxdepth 1); do
		if [[ $DIR =~ "frontend" ]]
		then
			if [[ -f $DIR/device/idVendor && -f $DIR/device/idProduct && $(cat $DIR/device/idVendor) == $1 && $(cat $DIR/device/idProduct) == $2 ]]; then
				return 0
			fi
		fi 
	done
	return 1
}


####Main

echo "******************************************************"
echo "        OpenSPA DVB-USB Modules Install Script        "
echo "******************************************************"
echo ""

if [ -f "/etc/.noautospadvb" ]
then
	echo "      Automatic installation is disabled      "
	echo "******************************************************"
	exit
fi

LSUSB_OUTPUT_FILE="/tmp/lsusb.out"
lsusb > $LSUSB_OUTPUT_FILE
mod_i=0


while read line
do 
	Ids=`echo $line | awk '{print $6}' | awk -F":" '{print "0x"$1";0x"$2}' | tr '[A-Z]' '[a-z]'`
	vendor=`echo $line | awk '{print $6}' | awk -F":" '{print $1}' | tr '[A-Z]' '[a-z]'`
	product=`echo $line | awk '{print $6}' | awk -F":" '{print $2}' | tr '[A-Z]' '[a-z]'`
	device_line=`cat /etc/dvb-usb-devices.list | grep "$Ids"`
	if [ ${#device_line} != "0" ]
	then
		mod_i=1
		name=`echo $device_line | awk -F";" '{print $3}'`
		package=`echo $device_line | awk -F";" '{print $4}'`
		module=`echo $package | sed -e 's/spa-dvb-module-//g' | sed -e 's/enigma2-plugin-drivers-//g' | sed -e 's/dvb-usb-rtl2832/dvb-usb-rtl28xxu/g' |sed -e 's/-/_/g'` 
		echo "Found: $name"
		if ! check_package $package; then
			echo "package $package Installed?: No"
			echo ""
			echo "************** Installing Packages ****************"
			opkg update > /dev/null
			opkg install $package > /dev/null
			echo "***************************************************"
			echo ""
		else
			echo "package $package Installed?: Yes"
			echo "Check for module in use..."
			if ! check_run $vendor $product; then
				echo "Module $module loaded, but Not in use...remove"
				modprobe -r $module > /dev/null
			else
				echo "Module $module in use"
			fi
		fi
		if ! check_module $module; then
			echo "Module $module loaded?: No"
			echo ""
			echo "**************** Loading Module *******************"
			echo "Loading module $module"
			modprobe $module > /dev/null
			echo "***************************************************"
			echo ""
		else
			echo "Module $module Loaded?: Yes"
		fi

		if ! check_package $package; then
			echo "Can not install the package $package"
		elif ! check_module $module; then
			echo "Can not load the module $module"
		fi
	fi
done < $LSUSB_OUTPUT_FILE
rm -f $LSUSB_OUTPUT_FILE &>/dev/null

if [ "$mod_i" -eq 0 ]; then
	echo "No supported devices found"
fi

echo ""
echo "******************************************************"

